<?php
/**
 * api_debug.php — Diagnostik untuk mengetahui kenapa episode hanya 21
 * Akses: /api_debug.php?bookId=41000119953
 * HAPUS FILE INI SETELAH SELESAI DEBUG!
 */
header('Content-Type: text/html; charset=utf-8');
require_once __DIR__ . '/api.php';

$bookId = preg_replace('/[^0-9]/', '', $_GET['bookId'] ?? '41000119953');

echo "<h1>🔍 Boniflix API Debug</h1>";
echo "<p><strong>BookID:</strong> $bookId</p>";
echo "<p><strong>Server:</strong> " . ($_SERVER['HTTP_HOST'] ?? 'unknown') . "</p>";
echo "<p><strong>PHP:</strong> " . phpversion() . "</p>";
echo "<p><strong>cURL:</strong> " . (function_exists('curl_init') ? '✅ tersedia' : '❌ TIDAK ADA') . "</p>";
echo "<p><strong>Cache Dir:</strong> " . CACHE_DIR . " — " . (is_writable(CACHE_DIR) ? '✅ writable' : (is_dir(CACHE_DIR) ? '⚠️ tidak writable' : '❌ tidak ada')) . "</p>";
echo "<hr>";

// ═══ Step 1: Test getBuildId ═══
echo "<h2>Step 1: getBuildId()</h2>";
// Clear cache dulu
$buildCacheFile = CACHE_DIR . md5('dramabox_build_id_v2') . '.json';
if (file_exists($buildCacheFile)) { @unlink($buildCacheFile); echo "<p>🗑️ Build ID cache dihapus</p>"; }

$t1 = microtime(true);
$buildId = getBuildId();
$t1e = microtime(true) - $t1;
if ($buildId) {
    echo "<p>✅ BuildID: <code>$buildId</code> ({$t1e}s)</p>";
} else {
    echo "<p>❌ <strong>GAGAL mendapatkan BuildID!</strong> ({$t1e}s)</p>";
    // Test raw request
    echo "<h3>Raw test: fetch dramaboxdb.com/in</h3>";
    $ch = curl_init('https://www.dramaboxdb.com/in');
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_CONNECTTIMEOUT => 15,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTPHEADER => [
            'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36',
            'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
        ],
    ]);
    $rawResp = curl_exec($ch);
    $rawCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $rawError = curl_error($ch);
    $effectiveUrl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);
    curl_close($ch);

    echo "<p>HTTP Code: $rawCode</p>";
    echo "<p>Effective URL: $effectiveUrl</p>";
    echo "<p>cURL Error: " . ($rawError ?: '(none)') . "</p>";
    echo "<p>Response Length: " . strlen($rawResp ?: '') . " bytes</p>";
    if ($rawResp) {
        $hasBuildId = preg_match('/"buildId"\s*:\s*"([^"]+)"/', $rawResp, $bm);
        echo "<p>Contains buildId: " . ($hasBuildId ? "✅ $bm[1]" : "❌ TIDAK") . "</p>";
        // Show first 500 chars
        echo "<details><summary>Response preview (500 chars)</summary><pre>" . htmlspecialchars(substr($rawResp, 0, 500)) . "</pre></details>";
    }
}
echo "<hr>";

// ═══ Step 2: Test discoverSlug ═══
echo "<h2>Step 2: discoverSlug($bookId)</h2>";
// Clear slug cache
$slugFile = CACHE_DIR . 'slug_map.json';
if (file_exists($slugFile)) {
    $slugMap = json_decode(file_get_contents($slugFile), true) ?: [];
    if (isset($slugMap[$bookId])) {
        echo "<p>📌 Slug sudah ada di cache: <code>" . htmlspecialchars($slugMap[$bookId]) . "</code></p>";
        unset($slugMap[$bookId]);
        file_put_contents($slugFile, json_encode($slugMap));
        echo "<p>🗑️ Slug cache untuk bookId ini dihapus</p>";
    }
}

$t2 = microtime(true);
$slug = discoverSlug($bookId);
$t2e = microtime(true) - $t2;
if ($slug) {
    echo "<p>✅ Slug: <code>$slug</code> ({$t2e}s)</p>";
} else {
    echo "<p>❌ <strong>GAGAL mendapatkan slug!</strong> ({$t2e}s)</p>";
    echo "<p>Ini berarti DramaBox Web API tidak bisa diakses dari hosting. Semua episode akan fallback ke megawe (21 ep max).</p>";
}
echo "<hr>";

// ═══ Step 3: Test dramaboxDataRequest ═══
echo "<h2>Step 3: dramaboxDataRequest (chapterList)</h2>";
if ($slug && $buildId) {
    $detailCacheFile = CACHE_DIR . md5('dbox_data_/in/movie/' . $bookId . '/' . $slug . '.json') . '.json';
    if (file_exists($detailCacheFile)) { @unlink($detailCacheFile); echo "<p>🗑️ Detail cache dihapus</p>"; }

    $t3 = microtime(true);
    $pageProps = dramaboxDataRequest("/in/movie/$bookId/$slug.json");
    $t3e = microtime(true) - $t3;

    if ($pageProps) {
        $chapterList = $pageProps['chapterList'] ?? [];
        $bookInfo = $pageProps['bookInfo'] ?? null;
        echo "<p>✅ pageProps diterima ({$t3e}s)</p>";
        echo "<p>📖 bookInfo: " . ($bookInfo ? htmlspecialchars($bookInfo['bookName'] ?? '?') : '❌ null') . "</p>";
        echo "<p>📺 chapterList count: <strong>" . count($chapterList) . "</strong></p>";
        if (count($chapterList) > 0) {
            echo "<p>Episode pertama: id=" . ($chapterList[0]['id'] ?? '?') . ", name=" . htmlspecialchars($chapterList[0]['name'] ?? '?') . "</p>";
            echo "<p>Episode terakhir: id=" . ($chapterList[count($chapterList)-1]['id'] ?? '?') . ", name=" . htmlspecialchars($chapterList[count($chapterList)-1]['name'] ?? '?') . "</p>";
            // Test cover→video
            $cover = $chapterList[0]['cover'] ?? '';
            if ($cover) {
                $vidUrl = coverToVideoUrl($cover);
                echo "<p>Cover→Video test: " . ($vidUrl ? "✅ <code>" . htmlspecialchars(substr($vidUrl, 0, 100)) . "...</code>" : "❌ gagal") . "</p>";
            }
        }
    } else {
        echo "<p>❌ <strong>GAGAL mendapatkan pageProps!</strong> ({$t3e}s)</p>";

        // Raw test
        $rawUrl = DRAMABOX_DOMAIN . "/_next/data/$buildId/in/movie/$bookId/$slug.json";
        echo "<p>Raw URL: <code>$rawUrl</code></p>";
        $ch = curl_init($rawUrl);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTPHEADER => [
                'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36',
                'Accept: application/json, */*',
            ],
        ]);
        $rawResp = curl_exec($ch);
        $rawCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $rawError = curl_error($ch);
        curl_close($ch);
        echo "<p>HTTP: $rawCode | Error: " . ($rawError ?: 'none') . " | Length: " . strlen($rawResp ?: '') . "</p>";
    }
} else {
    echo "<p>⏩ Dilewati karena slug/buildId tidak tersedia</p>";
}
echo "<hr>";

// ═══ Step 4: Test megawe allepisode ═══
echo "<h2>Step 4: megawe /allepisode (fallback)</h2>";
$t4 = microtime(true);
$rEps = megaweRequest('/api/dramabox/allepisode', ['bookId' => $bookId, 'lang' => MEGAWE_LANG]);
$t4e = microtime(true) - $t4;
$megaweEps = $rEps['data'] ?? [];
echo "<p>" . (count($megaweEps) > 0 ? '✅' : '❌') . " megawe allepisode: <strong>" . count($megaweEps) . " episodes</strong> ({$t4e}s)</p>";
echo "<hr>";

// ═══ Step 5: Test megawe chapterv2 (pagination) ═══
echo "<h2>Step 5: megawe /chapterv2 (pagination test)</h2>";
for ($page = 1; $page <= 5; $page++) {
    $t5 = microtime(true);
    $rChap = megaweRequest('/api/dramabox/chapterv2', ['bookId' => $bookId, 'lang' => MEGAWE_LANG, 'page' => $page]);
    $t5e = microtime(true) - $t5;
    $chapData = $rChap['data'] ?? [];
    $chapCount = is_array($chapData) ? count($chapData) : 0;
    echo "<p>Page $page: <strong>$chapCount</strong> items ({$t5e}s)</p>";
    if ($chapCount === 0) break;
    if ($chapCount > 0 && is_array($chapData)) {
        $first = $chapData[0];
        $last = $chapData[$chapCount - 1];
        echo "<p style='margin-left:20px;font-size:0.85em'>First: #" . ($first['chapterIndex'] ?? '?') . " " . htmlspecialchars($first['chapterName'] ?? '?') . "</p>";
        echo "<p style='margin-left:20px;font-size:0.85em'>Last: #" . ($last['chapterIndex'] ?? '?') . " " . htmlspecialchars($last['chapterName'] ?? '?') . "</p>";
    }
}
echo "<hr>";

// ═══ Step 6: Test megawe chapter (tanpa v2) ═══
echo "<h2>Step 6: megawe /chapter (non-v2)</h2>";
for ($page = 1; $page <= 5; $page++) {
    $rChap2 = megaweRequest('/api/dramabox/chapter', ['bookId' => $bookId, 'lang' => MEGAWE_LANG, 'page' => $page]);
    $chapData2 = $rChap2['data'] ?? [];
    $chapCount2 = is_array($chapData2) ? count($chapData2) : 0;
    echo "<p>Page $page: <strong>$chapCount2</strong> items</p>";
    if ($chapCount2 === 0) break;
    if ($chapCount2 > 0 && is_array($chapData2)) {
        $first = $chapData2[0];
        $last = $chapData2[$chapCount2 - 1];
        echo "<p style='margin-left:20px;font-size:0.85em'>First: #" . ($first['chapterIndex'] ?? '?') . " " . htmlspecialchars($first['chapterName'] ?? '?') . "</p>";
        echo "<p style='margin-left:20px;font-size:0.85em'>Last: #" . ($last['chapterIndex'] ?? '?') . " " . htmlspecialchars($last['chapterName'] ?? '?') . "</p>";
        // Show structure of first item
        if ($page === 1) {
            echo "<details><summary>Structure first item page 1</summary><pre>" . htmlspecialchars(json_encode($first, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)) . "</pre></details>";
        }
    }
}
echo "<hr>";

// ═══ Step 7: Full getDetail result ═══
echo "<h2>Step 7: getDetail() final result</h2>";
// Clear detail cache
$detailCacheFile2 = CACHE_DIR . md5('detail_v3_' . $bookId) . '.json';
if (file_exists($detailCacheFile2)) { @unlink($detailCacheFile2); echo "<p>🗑️ detail_v3 cache dihapus</p>"; }

$t7 = microtime(true);
$detail = getDetail($bookId);
$t7e = microtime(true) - $t7;

if ($detail) {
    $eps = $detail['episodes'] ?? [];
    $drama = $detail['detail'] ?? [];
    echo "<p>✅ Drama: <strong>" . htmlspecialchars($drama['title'] ?? '?') . "</strong></p>";
    echo "<p>📺 Total episodes loaded: <strong style='font-size:1.5em;color:" . (count($eps) > 21 ? 'green' : 'red') . "'>" . count($eps) . "</strong></p>";
    echo "<p>📊 chapter_count (from API): <strong>" . ($drama['chapter_count'] ?? '?') . "</strong></p>";
    echo "<p>⏱️ Time: {$t7e}s</p>";

    if (count($eps) > 0) {
        echo "<p>First ep: #" . ($eps[0]['episode_number'] ?? '?') . " " . htmlspecialchars($eps[0]['episode_name'] ?? '?') . "</p>";
        $lastEp = $eps[count($eps) - 1];
        echo "<p>Last ep: #" . ($lastEp['episode_number'] ?? '?') . " " . htmlspecialchars($lastEp['episode_name'] ?? '?') . "</p>";

        // Check how many have video
        $withVideo = 0;
        foreach ($eps as $e) {
            if (!empty($e['video']['mp4']) || !empty($e['video']['m3u8'])) $withVideo++;
        }
        echo "<p>Episodes with video URL: <strong>$withVideo</strong> / " . count($eps) . "</p>";
    }
} else {
    echo "<p>❌ <strong>getDetail() returned null</strong> ({$t7e}s)</p>";
}

echo "<hr><p style='color:gray'>Debug selesai. <strong>Hapus file ini dari server!</strong></p>";
